import $ from "jquery";
import RSVP from "rsvp";
import { clone } from "./utils.js";

// APIS for accessing kraken for information about channels and games
// These all return a promise

function getFeaturedChannels() {
  return RSVP.resolve($.ajax('https://api.twitch.tv/kraken/streams/featured?limit=100', {
    dataType: 'json'
  })).then((resp) => {
    return resp.featured.map((item) => {
      return item.stream;
    });
  });
}

function getAccessTokenForChannel(channel) {
  var krakenUrl = `https://api.twitch.tv/channels/${channel}/access_token`;

  return new RSVP.Promise(function (resolve, reject) {
    $.ajax(krakenUrl, {
      dataType: 'json'
    }).then(function (resp) {
      resolve(resp);
    });
  });
}

function getHLSUrlForChannel(channel) {
  var baseParams = {
    player: "twitchweb",
    p: 0,
    type: "any",
    allow_source: "true",
    allow_audio_only: "true"
  };


  var hlsURL = `http://usher.justin.tv/api/channel/hls/${channel.toLowerCase()}.m3u8`;

  return getAccessTokenForChannel(channel).then(function(token) {
    var params = clone(baseParams);
    params.token = encodeURIComponent(token.token);
    params.sig = encodeURIComponent(token.sig);

    var encodedParams = [];
    for (var key in params) {
      encodedParams.push(`${key}=${params[key]}`);
    }
    var URLParams = encodedParams.join('&');
    return `${hlsURL}?${URLParams}`;
  });
}

export default {
  getFeaturedChannels: getFeaturedChannels,
  getHLSUrlForChannel: getHLSUrlForChannel
};
