package docker_jenkins_test

import (
	"fmt"
	"testing"

	"github.com/go-redis/redis"
)

// The host name comes from the service's name in docker-compose.yml.
// (Containers can talk to each other using a network created by docker-compose.
//  These host names are also set up by docker-compose.
//  https://docs.docker.com/compose/networking/ )
const redisHostName = "redis"

func TestSomething(t *testing.T) {
	t.Log("neat")
}

// Test sending a request to a service in the environment.
func TestRedis(t *testing.T) {
	client := redis.NewClient(&redis.Options{
		Addr: fmt.Sprintf("%s:%d", redisHostName, 6379),
	})

	val, err := client.Ping().Result()
	if err != nil {
		t.Fatalf("%+v", err)
	}

	t.Log(val)
}
