# Creator-Collab Docs

Source for Creator Collaboration team documentation hosted here:
https://git-aws.internal.justin.tv/pages/creator-collab/docs/.

## Contributing

The site is generated using [Jekyll](https://jekyllrb.com/) and the [Just the Docs](https://pmarsceill.github.io/just-the-docs/) theme, and hosted on Github Pages.  To update the site, edit the files in the `docs` directory and push changes to `master`.  Github Pages will automatically rebuild the site using the latest files in master.

### Create a top-level page

To create a top level page, create a folder under `docs`, and a markdown file with the same name in that folder.  For example, if we were creating a page called "Squad Stream", our directory structure would look like,

```
docs
|
+-- squad-stream
    |
    +-- squad-stream.md
```

Each page needs a YAML front matter, a small YAML doc that precedes the page's content.  For a top level page, you'll need to add the following front matter.  `nav_order` determines where this page's title appears in the side nav.

```
---
layout: default
title: Squad Stream
nav_order: 1
---

# Squad Stream

My content, written in Markdown.
```

### Create a 2nd level page

To create a second level page, create a folder in the top level page's folder, and create a markdown file with the same name in that folder.  For example, if we wanted to add an API page under Squad Stream, our directory structure would look like,

```
docs
|
+-- squad-stream
    |
    +-- squad-stream.md
    |
    +-- api
        |
        +--api.md
```

We need to update both the parent's and child's front matters for the navigation to render correctly.

#### Parent

Add the `has_children` and `permalink` fields to the parent's front-matter.  `permalink` should contain the relative URL for the parent's page.  Note: The trailing slash is important.

`squad-stream.md`
```
---
layout: default
title: Squad Stream
nav_order: 1
has_children: true
permalink: /docs/squad-stream/
---

# Squad Stream
```

#### Child

Add the `parent` field to the child's front-matter.  It should contain the title of the parent page.

`api.md`
```
---
layout: default
title: API
nav_order: 1
parent: Squad Stream
---

# API

API content ...
```

### Create a 3rd level page

To create a third level page, create a folder in the second level page's folder, and create a markdown file with the same name in that folder.  For example, if we wanted to add a Pubsub page under API, our directory structure would look like,

```
docs
|
+-- squad-stream
    |
    +-- squad-stream.md
    |
    +-- api
        |
        +-- api.md
        |
        +-- pubsub
            |
            + pubsub.md
```

We need to update both the 2nd's and 3rd level pages' front matters for the navigation to render correctly.

#### 2nd level page front matter

Add the `has_children` and `permalink` fields to the 2nd Level Page's front-matter.  `permalink` should contain the relative URL for the parent's page.  Note: The trailing slash is important.

`api.md`
```
---
layout: default
title: API
nav_order: 1
parent: Squad Stream
has_children: true
permalink: /docs/squad-stream/api/
---

# API

API content ...
```

#### 3rd level page front matter

Add the `parent` and `grant_parent` fields to the 3nd Level Page's front-matter.  `parent` should be the 2nd Level Page's title, and `grand_parent` should be the top level page's title.

`pubsub.md`
```
---
layout: default
title: Pubsub
nav_order: 1
grand_parent: Squad Stream
parent: API
---

# Pubsub

Pubsub content ...
```

### Preview changes

Pre-reqs: Docker

Run `serve.sh` to build the site and serve it locally at [http://0.0.0.0:4000/pages/creator-collab/docs/](http://0.0.0.0:4000/pages/creator-collab/docs/).  Jekyll will automatically rebuild the site whenever files in the current directory change.

Note: If you modify `_config.yml`, you will have to re-run `serve.sh` for your local site to show the changes.
