---
layout: default
title: Ads
nav_order: 1
parent: Design
grand_parent: Squad Stream
---

# Ads

In squad mode, ads is only displayed on each viewer's current the primary player, regardless of roll type and ad type. During an ad play, the channel switcher is be disabled, and a viewer is not be able to change primary player. 

Determining which channel to display ads on is achieved by:

  - On client-side ads by checking PlayerType in [player-ui](https://git-aws.internal.justin.tv/video/player-ui/blob/develop/src/js/ads/declining-manager.js#L193)
  - On server-side ads by checking in [<i class='fab fa-github'></i> dads](https://git-aws.internal.justin.tv/ads/dads), the PlayerType and calling ShouldShowAds endpoint
    
    > https://git-aws.internal.justin.tv/ads/dads/blob/master/backend/backend.go#L423

A call is made from each Twilight client to Meepo SetPrimaryPlayer endpoint:
  
  - On initial load
  - Every time primary player is switched
  - At a fixed 3 minutes interval
  
[SetPrimaryPlayer](https://git-aws.internal.justin.tv/twitch-events/meepo/blob/master/internal/api/set_primary_player.go) endpoint stores in a cache, for every unique device and squad ID; the channel currently in the primary player position.

[ShouldShowAd](https://git-aws.internal.justin.tv/twitch-events/meepo/blob/master/internal/api/should_show_ad.go) endpoint utilizes this information to determine whether an ad should be declined (when not in the primary player position)

## Requirements

  - Viewers should see pre-roll ads on the primary player when they load the squad page.  
    
    > <b>Note:</b> There is already a 5 minute period cooldown for showing pre-rolls. Viewers will not see a pre-roll if they saw a pre-roll on the same channel in the last 5 minutes.
  
  - Viewers should only see mid-roll ads on their <b>current</b> primary player.
  - While an ad is playing, a viewer should not be able to change the layout or move another player to the primary position.
  - Our implementation should not give a viewer a way to decline ads on arbitrary channels.

## How Ad Declines Work

On web, we support client-side and server-side ad insertion. Both support applying business rules to determine whether a viewer should see an ad or not.

### *Client-Side Ad Insertion*

When client-side ad insertion is used, the video system adds special tags to the video segments that are being served to a viewer. These tags instruct the viewer’s player to insert an ad. The player processes the tags, runs its own logic to determine if the viewer should see an ad, and then requests an ad from a provider.

The logic that the player runs to determine whether it should decline the ad is implemented by the [DecliningAdsManager class](https://git-aws.internal.justin.tv/video/player-ui/blob/develop/src/js/ads/declining-manager.js#L248) in Player-UI.  

### *Server-Side Ad Insertion*

When server-side ad insertion is being used, the ad is inserted directly into the video stream, and the player cannot distinguish between the creator’s video segments and the ad’s video segments.

The Declining Ads Service ([<i class='fab fa-github'></i> dads](https://git-aws.internal.justin.tv/ads/dads)) is responsible for determining whether an ad should be inserted into a viewer’s video stream. It can make requests to other services to gather information about the channel or the viewer.

![Ads flow](ads-flow.png)

DAds’s ShowAds is given the viewer’s user ID, device ID, player type, and the channel that the viewer is watching.  The player type is captured when the viewer’s player is being initialized (when the nauth token is created).  This means that a request for a viewer watching a squad page should include a “squad-primary” or “squad-secondary” player type.  However, the player type will not reflect that player’s current position if the viewer chooses a new primary player.

## Proposal for Declining Server-Side Ads

To support declining server-side ads for squad stream secondary players, we need to be able to determine:
  
  - whether the viewer is watching a squad stream
  - whether the player is in a secondary position

We will assume that a viewer is watching a squad stream if:

  - The player type is either “squad-primary” or “squad-secondary”
  - The player’s channel is currently a member of live squad

We can use the player type to determine whether a player is in a secondary position when evaluating pre-rolls.  For mid-rolls, Meepo will store the channel that each viewer has in the primary position.

![Decline Ads flow](../decline-ads-flow.png)

## Keeping track of the channels in a squad

Meepo currently supports getting a channel’s squad, using a cache to reduce the number of queries that hit the database.  Cache entries currently have a TTL of 10 minutes.

## Keeping track of a viewer’s primary player

When a viewer goes to a Squad page, Twilight will call the setSquadStreamPrimaryPlayer mutation, passing in the viewer’s device ID, the squad ID and the channel ID of their primary player.  Twilight should make the call periodically and when the primary player changes.

  - The time between calls should be configurable in Savant, defaulting to 3 minutes.
  - There should be a random delay before periodically calling setSquadStreamPrimaryPlayer.  This is meant to prevent large groups of viewers from calling setSquadStreamPrimaryPlayer at the same time and causing spikes in the traffic.
  - We should be able to disable the polling from Savant, so we can quickly reduce the load on our systems in an emergency.
  
```
type Mutation {
    setSquadStreamPrimaryPlayer(input: SetSquadStreamPrimaryPlayerInput!): 
        SetSquadStreamPrimaryPlayerResponse
}

input SetSquadStreamPrimaryPlayerInput {
    deviceID: ID!
    squadStreamID: ID!
    primaryPlayerID: ID!
}

type SetSquadStreamPrimaryPlayerPayload {
    primaryPlayer: User
}
```

GraphQL in turn sends a request to Meepo’s SetPrimaryPlayer.

```
rpc SetPrimaryPlayer(SetPrimaryPlayerRequest)
    returns (SetPrimaryPlayerRequestResponse);

message SetPrimaryPlayerRequest {
    string device_id = 1;
    string squad_id = 2;
    string primary_player_channel_id = 3;
}
message SetPrimaryPlayerResponse {
    string primary_player_channel_id = 1;
}
```

Meepo stores the channel ID in its cache, using a composite a key made from the device ID, and squad ID.  The cache entries should have a TTL of 10 minutes.  

## Determining whether to show an ad

  - When DAds needs to determine whether to insert an ad into the viewer’s session, it runs a series of decision functions.
  - The squad stream decision function will first check if the viewer’s player type is either “squad-primary” or “squad-secondary”.  If it is, the user may be watching a squad stream. If it is not, the viewer is watching from some other area of the site (channel page, home page) and the ad should be allowed.
  - If the player type indicates that the viewer may be watching a squad stream, then DAds sends a request to Meepo’s ShouldDeclineAd endpoint.
    - The call to Meepo should wrapped in a Hystrix circuit breaker (or something similar) to insulate DAds from Meepo failures.
    
```
rpc ShouldDeclineAd(ShouldDeclineAdRequest)
    returns (ShouldDeclineAdResponse);

message ShouldDeclineAdRequest {
    enum AdType {
        PRE_ROLL = 0;
        MID_ROLL = 1;
    }
    enum PlayerType {
        PRIMARY = 0;
        SECONDARY = 1;
    }

    AdType ad_type = 1;
    string channel_id = 2;
    string device_id = 3;
    string user_id = 4;
    PlayerType player_type = 5;
}

message ShouldDeclineAdResponse {
    bool should_decline = 1;
}
```

Meepo first checks whether the channel is part of a live squad.  If the channel is not part of a live squad, then Meepo returns that the ad should be allowed.

Meepo then needs to check whether the viewer has the channel in a primary or secondary position:

## Determining whether player position for pre-rolls

Meepo can use the player-type to determine the player’s position for pre-rolls.  Since pre-rolls run when the squad page first loads, the player type that DAds’ ShowAds receives should accurately indicate the player’s position.

Meepo should return that an ad should be declined if the player type is SECONDARY.

## Determining whether player position for mid-rolls

Meepo can’t use the player-type to determine the player’s position for mid-rolls because the player-type that DAds receives is captured when the players are initialized, and will be out of date if the viewer swaps the primary player.

Meepo instead loads the viewer’s primary player from the cache, using a composite key made from the device ID and squad ID.

  - If an entry could not be found in the cache, then we return that the ad should be allowed.
  - If an entry exists in the cache that indicates that the channel is in the primary position, then Meepo returns that the ad should be allowed.
  - Otherwise, an entry exists in the cache that indicates that the channel is in a secondary position, and Meepo returns that the ad should be declined.
  
## Work Breakdown

The tasks related to supported ads in Squad Stream are tracked in [EV-886 SS: Ads epic](https://jira.twitch.com/browse/EV-886).
