package main

import (
	"os"
	"strconv"
	"time"

	"code.justin.tv/creator-collab/log"
	"code.justin.tv/creator-collab/log/errors"
)

func main() {
	useDev := false
	logger := log.NewDevelopmentLogger()

	if !useDev {
		rollbarToken := os.Getenv("ROLLBAR_TOKEN")
		rollbarEnv := "development"
		logger = log.NewProductionLogger(rollbarToken, rollbarEnv)
	}

	logger.Info("server started", log.Fields{
		"workers": 3,
		"queue":   "http://queue.com",
	})

	err := followChannel("a123411", "999999")
	logger.Error(err, log.Fields{"operation": "host"})
	time.Sleep(time.Second * 10)
}

func followChannel(sourceID, targetID string) error {
	err := updateDB(sourceID, targetID)
	if err != nil {
		return errors.Wrap(err, "follow channel failed")
	}

	return nil
}

func updateDB(sourceID, targetID string) error {
	_, err := strconv.Atoi(sourceID)
	if err != nil {
		return errors.Wrap(err, "updating follow table failed", errors.Fields{
			"sourceID": sourceID, "targetID": targetID})
	}

	return nil
}
