package main

import (
	"fmt"

	"code.justin.tv/creator-collab/log"
	"code.justin.tv/creator-collab/log/errors"
)

func main() {
	LogSomeThings(log.NewDevelopmentLogger())
	LogSomeThings(log.NewProductionLogger("", ""))

}

func LogSomeThings(logger log.Logger) {
	logger.Info("service is starting")

	logger.Info("service is starting", log.Fields{
		"environment": "development",
		"numWorkers":  5,
	})

	logger.Error(fmt.Errorf("user not found"))

	logger.Error(errors.New("team not found"))

	logger.Error(errors.New("event not found", errors.Fields{
		"id": "WQDSFEW334534G",
	}))

	logger.Error(errors.Wrap(
		errors.Wrap(
			fmt.Errorf("desc is empty"),
			"adding event to table failed"),
		"creating event failed",

		errors.Fields{
			"operation": "create_event",
			"title":     "My fun new event",
			"channel":   "324432432",
			"desc":      "",
		}))
}
