package log

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestNewProductionLogger(t *testing.T) {
	logger := NewProductionLogger("", "development")
	require.NotNil(t, logger)

	logger.Debug("a message")
	logger.Info("a message")
	logger.Error(fmt.Errorf("an error"))
}

func TestNewDevelopmentLogger(t *testing.T) {
	logger := NewDevelopmentLogger()
	require.NotNil(t, logger)

	logger.Debug("a message")
	logger.Info("a message")
	logger.Error(fmt.Errorf("an error"))
}
