module.exports = {
  root: true,
  parserOptions: {
    ecmaVersion: 5,
    sourceType: 'script',
    ecmaFeatures: {
      globalReturn: false,
      impliedStrict: true
    }
  },
  plugins: ['ignore-liquid'],
  extends: 'eslint:recommended',
  env: {
    'browser': true,
    'jquery': true
  },
  rules: {
    // Rules removed from eslint:recommended
    'indent': [0, 2],

    // Rules added beyond eslint:recommended
    'arrow-spacing': [2, {
      'before': true,
      'after': true
    }],
    'camelcase': [2, {
      properties: 'never'
    }],
    'comma-dangle': 2,
    'curly': [2, 'all'],
    'eol-last': 2,
    'eqeqeq': 2,
    'linebreak-style': 2,
    'no-caller': 2,
    'no-case-declarations': 2,
    'no-else-return': 2,
    'no-eq-null': 2,
    'no-eval': 2,
    'no-multi-str': 2,
    'no-new': 2,
    'no-shadow': 2,
    // 'no-var': 2,         // es6 only
    'operator-linebreak': [2, 'after'],
    //'prefer-spread': 2,   // es6 only
    //'prefer-template': 2, // es6 only
    'semi': 2,
    'space-in-parens': [2, 'never'],
    'space-unary-ops': [2, {
      'words': false,
      'nonwords': false
    }],

    // Warnings added. These are issues to be fixed up
    // as commits are made to reduce incidents until they can be
    // completely fixed and moved into errors
    'no-console': 1
  }
};
