package main

import (
	"encoding/json"
	"fmt"
	"os"

	"code.justin.tv/cs/pboard-submitter-go/pkg/client"
	"code.justin.tv/jleroux/go-isengard2/service"
	"code.justin.tv/jleroux/go-isengard2/service/isengard"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/spf13/cobra"
)

var (
	accountID   = "901716405836"
	role        = "Admin"
	region      = "us-east-2"
	functionARN = "arn:aws:lambda:us-east-2:901716405836:function:createQuote"
)

var pboardClient client.Client

// rootCmd represents the base command when called without any subcommands
var rootCmd = &cobra.Command{
	Use:          "pboard-cli",
	Short:        "command line client for the pboard api",
	SilenceUsage: true,
}

func init() {
	svc, err := service.NewIsengardService()
	if err != nil {
		fmt.Printf("Failed to initiate isengard client (you probably need to run mwinit): %v\n", err)
		os.Exit(1)
	}

	// Generate an AWS Session using isengard
	sess, err := getSession(svc, accountID, role, region)
	if err != nil {
		fmt.Printf("Failed to generate credentials for PBoard: %v\n", err)
		os.Exit(1)
	}

	pboardClient = client.New(sess, functionARN)
}

func main() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}

func getPboardClient() {

}

func getSession(svc *isengard.Isengard, accountID, role, region string) (*session.Session, error) {
	output, err := svc.GetAssumeRoleCredentials(&isengard.GetAssumeRoleCredentialsInput{
		AWSAccountID: aws.String(accountID),
		IAMRoleName:  aws.String(role),
	})

	if err != nil {
		return nil, err
	}

	result := &service.AssumeRoleResult{}
	err = json.Unmarshal([]byte(*output.AssumeRoleResult), result)
	if err != nil {
		return nil, err
	}

	creds := credentials.NewStaticCredentials(result.Credentials.AccessKeyID, result.Credentials.SecretAccessKey, result.Credentials.SessionToken)

	// Create an AWS session
	return session.NewSession(&aws.Config{
		Region:      aws.String(region),
		Credentials: creds,
	})
}
