package main

import (
	"errors"
	"fmt"

	"code.justin.tv/cs/pboard-submitter-go/pkg/client"
	"github.com/manifoldco/promptui"
	"github.com/spf13/cobra"
)

func init() {
	quoteCmd := &cobra.Command{
		Use:   "quote",
		Short: "quote",
		Long:  `quote commands`,
	}
	rootCmd.AddCommand(quoteCmd)
	initAddQuote(quoteCmd)
}

func validateString(input string) error {
	if input == "" {
		return errors.New("Empty quote")
	}
	return nil
}

func initAddQuote(parentCmd *cobra.Command) {
	var cmd = &cobra.Command{
		Use:  "add",
		Args: cobra.ExactArgs(0),
	}
	parentCmd.AddCommand(cmd)

	cmd.RunE = func(cmd *cobra.Command, args []string) error {
		// Grab the quote
		prompt := promptui.Prompt{
			Label:    "Quote",
			Validate: validateString,
		}

		quote, err := prompt.Run()

		if err != nil {
			fmt.Println(err)
			//	panic(err)
		}

		fmt.Println(quote)

		prompt = promptui.Prompt{
			Label:    "Submitter",
			Validate: validateString,
		}

		submitter, err := prompt.Run()

		if err != nil {
			fmt.Println(err)
		}

		fmt.Println(submitter)

		promptSelect := promptui.Select{
			Label: "Select Language",
			Items: []string{"zh", "zh-hans", "zh-hant", "nl", "en", "fi", "fr", "gd", "de", "it", "ja", "ko", "no", "pl", "pt", "bt-br", "ro", "ru", "es", "es-mx", "sv", "th", "tr", "vi"},
		}

		_, language, err := promptSelect.Run()

		if err != nil {
			fmt.Println(err)
		}

		quoteID, err := pboardClient.SubmitQuote(client.SubmitQuoteRequest{
			Quote:     quote,
			Submitter: submitter,
			Language:  language,
		})

		if err != nil {
			fmt.Println(err)
		} else {
			fmt.Printf("Quote added %v\n", quoteID)
		}

		return nil
	}
}
