from __future__ import print_function
import json
import uuid
from datetime import date
import time
import boto3
from botocore.exceptions import ClientError

def lambda_handler(event, context):

    #Validating user provided input
    validationErrors = []
    languageTags = ["bt-br", "de", "en", "es", "es-mx", "fi", "fr", "gd", "it", "ja", "ko", "nl", "no", "pl", "pt", "ro", "ru", "sv", "th", "tr", "vi", "zh", "zh-hans", "zh-hant"]

    if not event['quote']:
        validationErrors.append("quote")
    if not event['submitter']:
        validationErrors.append("submitter")
    if not event['language']:
        validationErrors.append("language")

    if len(validationErrors) > 0:
        return {
            'success': False,
            'message': 'Failed to add quote. Please provide ' + ', '.join(validationErrors)
        }

    # Data type checks
    if type(event['quote']) != str:
        return {
            'success': False,
            'message': 'Invalid type. Quote must be str.'
        }
    if type(event['submitter']) != str:
        return {
            'success': False,
            'message': 'Invalid type. Submitter must be str.'
        }

    if type(event['language']) != str:
        return {
            'success': False,
            'message': 'Invalid type. Language must be str.'
        }

    if event['language'] not in languageTags:
        return {
            'success': False,
            'message': 'Invalid Language. Please choose a supported tag (bt-br, de, en, es, es-mx, fi, fr, gd, it, ja, ko, nl, no, pl, pt, ro, ru, sv, th, tr, vi, zh, zh-hans, zh-hant).'
        }

    dynamodb = boto3.resource('dynamodb', region_name='us-east-2')
    table = dynamodb.Table('quotes')

    quoteID = str(uuid.uuid4())
    today = str(date.today())
    days = 90*60*60*24
    ttl = int(time.time()) + days

    try:
        response = table.put_item(
        Item={
                'date': today,
                'quote': event['quote'],
                'quoteID': quoteID,
                'submitter': event['submitter'],
                'language': event['language'],
                'ttl': ttl
            }
        )
    except ClientError as e:
        print(e.response['Error']['message'])
        return {
            'success': False,
            'message': 'Failed to add quote, please talk to Turner.'
        }
    else:
        return {
            'success': True,
            'message': 'OK. Quote Added.',
            'quoteID': quoteID
        }
