import json
import boto3

print('Loading function')


def lambda_handler(event, context):
    print(event)

    dynamodb = boto3.resource('dynamodb', region_name='us-east-2')
    table = dynamodb.Table('quotes')

    results = []

    response = table.scan()

    for i in response['Items']:
        results.append(i)

    while 'LastEvaluatedKey' in response:
        response = table.scan(
            ExclusiveStartKey=response['LastEvaluatedKey']
        )

        for i in response['Items']:
           results.append(i)


    return {
    "isBase64Encoded": False,
    "statusCode": 200,
    "statusDescription": "200 OK",
    "headers": {
        "Content-Type": "application/json",
        "access-control-allow-origin": "*",
    },
    "body": json.dumps(results)
}
