function GET(url, callback) {
    var xhr = new XMLHttpRequest();

    xhr.onload = function () {
      if (xhr.status >= 200 && xhr.status < 300) {
        callback(xhr.response);
      } else {
        console.log('GET request failed.');
      }
      console.log('Status: ' + xhr.status);
    };

    xhr.open('GET', url);
    xhr.send();
  }

  function setQuoteData(response) {
    var quotes = JSON.parse(response);
    console.log("Quotes loaded successfully.")

    window.quotes = quotes;
    window.quoteIdx = 0;

    shuffle(window.quotes);
    console.log(window.quotes);
    renderQuote(window.quotes[window.quoteIdx]);
    window.quoteUpdateInterval = setInterval(updateQuote, 8*1000)
  }

  function shuffle(array) {
    var currentIndex = array.length, temporaryValue, randomIndex;

    while (0 !== currentIndex) {
      randomIndex = Math.floor(Math.random() * currentIndex);
      currentIndex -= 1;
      temporaryValue = array[currentIndex];
      array[currentIndex] = array[randomIndex];
      array[randomIndex] = temporaryValue;
    }

    return array;
  }

  var sanitizeHTML = function (str) {
    var temp = document.createElement('div');
    temp.textContent = str;
    return temp.innerHTML.replace('\n', '<br />');
  };

  function renderQuote(quote) {
    document.getElementById("quoteSubmitter").innerHTML = sanitizeHTML(quote.submitter);
    document.getElementById("quoteDate").innerHTML = sanitizeHTML(quote.date);
    document.getElementById("quoteBody").innerHTML = sanitizeHTML(quote.quote);
    $('h1').css('fontSize', '100px');
  }

  function updateQuote() {
    if (window.quotes.length==0) {
      console.log("No quotes returned.");
      return;
    }

    if (window.quoteIdx+1==window.quotes.length) {
      if (window.quoteUpdateInterval) {
        clearInterval(window.quoteUpdateInterval);
        window.quoteUpdateInterval = null;
      }

      getQuotes();
      return;
    }

    window.quoteIdx++;
    renderQuote(window.quotes[window.quoteIdx]);
  }


  function getQuotes(){
    GET('https://api.pboard.twitchpanel.com/', setQuoteData);
  }

  getQuotes()
