# Pong

Pong is a simple service to connect the Customer Support portals of Amazon and Twitch.

Here's a high-level overview of the pipelines Pong manages:

### Twitch -> Amazon
The following are the steps for a Twitch ticket to be created in Amazon's Customer Support portal:

1) Desk sends a POST request to `/tickets/amazon` with the [ticket payload](https://git-aws.internal.justin.tv/cs/pong/blob/master/api/amazon.go#L18-L29)

2) Pong validates the request payload and returns an error if this validation fails

3) Pong retrieves additional user data from the users service

4) Pong pushes an encrypted payload to the `pong-ingress-queue` SQS queue

5) Amazon pushes an encrypted payload to the `pong-production-ingress-amazon-ack` SQS queue, notifying Pong that Amazon successfully processed the payload and created the ticket

6) Pong sends an API request to Desk to mark the ticket as transferred

### Amazon -> Twitch
The following are the steps for an Amazon ticket to be created in Twitch's Customer Support portal:

1) Amazon pushes an encrypted payload to the `pong-production-ingress-amazon` SQS queue

2) Pong retrieves user, partnership, turbo, and prime information for the Twitch ID in the ticket

3) Pong sends an API request to Desk to create the ticket

# Development

In order to develop on Pong locally, you'll need:

1. go 1.10.7
1. jq
1. aws cli
1. sandstorm
1. isengard access to `twitch-web-dev`
1. a script (provided below, isengard work based on work by `cmolik`) to fetch temporary aws credentials for the assumed role
1. `mwinit`
1. Some form of AWS Credential management, like [Voucher](https://git-aws.internal.justin.tv/fire/dotfiles/tree/master/voucher)

## Setup

TODO: jq https://github.com/stedolan/jq/wiki/Installation
TODO: AWS CLI https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-install.html#install-sections
TODO: mwinit https://w.amazon.com/index.php/NextGenMidway/UserGuide#Token_Registration and https://wiki.twitch.com/display/AD/Using+mwinit+from+Twitch+VPN
TODO: Voucher https://git-aws.internal.justin.tv/fire/dotfiles/tree/master/voucher#setup
TODO: Isengard ( ask Xangold to add you to the twitch-safety-core amazon POSIX group )
TODO: Sandstorm ( might not need this if we're going to use the api based method )

### Credential Management

### Running Locally

Presuming you've set everything up and it's in a functional state, you should be able to run Pong locally with these four steps, while inside the local repo directory:

1. `update-aws-cli-creds`
1. `` `make env` ``
1. `make build`
1. `./pong`

And with that, Pong should be running on your local system, ready to listen and publish to the staging sqs queues.

TODO: Local dev is still competing with the staging instances, so it's possible you won't be able to snag a payload if the staging instance is faster than you.

# Debugging
If there are any issues, error information is sent to Rollbar. These errors were carefully crafted to avoid sending any PII.

Additionally, logs are written to `/var/log/jtv/pong.log` on all Pong EC2 instances. Again, no PII is included in any of these logs.

### Desk fails when sending data to Pong
Check the request logs in Desk. When Pong encounters a validation error in the request payload, an error message is included in the response that should help with debugging.

### Pong fails to process Amazon payloads
Check the errors that appear in Rollbar and see if the available information is sufficient. If not, you'll need to do the following:

1) Understand that you are about to access personally identifiable information that can never be shared. Not in Slack, not over Twitter, etc

2) Understand that you are about to download an RSA private key that can never be shared. Not over email, not in Slack, etc

3) Download the Twitch RSA private key. It can be found in `/opt/twitch/pong/etc/secrets/AMAZON_CLIENT_DECRYPTION_PRIVATE_KEY ` on any Pong production EC2 instance

4) From the `twitch-web-aws` AWS console, download the encrypted payload from the correct SQS deadletter queue. For Amazon ticket acks, this is the `pong-production-ingress-amazon-ack-deadletter` SQS queue. For Twitch ticket creation, this is the `pong-production-ingress-amazon-deadletter` SQS queue

5) Download [this code](https://git-aws.internal.justin.tv/gist/potjorda/1bffb2b5199de31809d018b42a6007ee) into `$GOPATH/src/code.justin.tv/cs/pong/tickets/amazon`

5) Replace the string `TODO: COPY PASTE PRIVATE KEY HERE` with the RSA private key from step 3

6) Replace the string `TODO: COPY PASTE JSON PAYLOAD 1 HERE` with the payload retrieved from step 4

7) Run `go test -v code.justin.tv/cs/pong/tickets/amazon`. The decrypted payload data will be output to the console

8) *DO NOT SKIP THIS STEP!* DELETE `$GOPATH/src/code.justin.tv/cs/pong/tickets/amazon`

After you've completed debugging, clear out any messages that remain in the SQS queue from step 4