package api

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestCreateAmazonTicket(t *testing.T) {
	t.Log("TODO")
}

func TestValidateAmazonTicketRequest(t *testing.T) {
	atr := getSampleAmazonTicketRequest()
	assert.NoError(t, validateAmazonTicketRequest(atr))

	atr = getSampleAmazonTicketRequest()
	atr.DeskCaseID = 0
	assert.Error(t, validateAmazonTicketRequest(atr))

	atr = getSampleAmazonTicketRequest()
	atr.DeskSubjectEscaped = ""
	assert.Error(t, validateAmazonTicketRequest(atr))

	atr = getSampleAmazonTicketRequest()
	atr.DeskBodyEscaped = ""
	assert.Error(t, validateAmazonTicketRequest(atr))

	atr = getSampleAmazonTicketRequest()
	atr.TwitchUserID = ""
	assert.Error(t, validateAmazonTicketRequest(atr))

	atr = getSampleAmazonTicketRequest()
	atr.AmazonPrimeCountry = ""
	assert.Error(t, validateAmazonTicketRequest(atr))

	atr = getSampleAmazonTicketRequest()
	atr.AmazonPrime = false
	atr.AmazonPrimeCountry = ""
	assert.NoError(t, validateAmazonTicketRequest(atr))
}

func getSampleAmazonTicketRequest() *AmazonTicketRequest {
	return &AmazonTicketRequest{
		DeskCaseID:         1337,
		DeskSubjectEscaped: "desk ticket subject",
		DeskBodyEscaped:    "desk ticket body",
		TwitchUserID:       "twitch-user-id",
		TwitchPartner:      true,
		AmazonPrime:        true,
		AmazonPrimeCountry: "US",
	}
}
