package api

import (
	"net/http"

	"code.justin.tv/common/twitchhttp"
	desk "code.justin.tv/cs/desk-client"
	"code.justin.tv/cs/pong/logger"
	"code.justin.tv/cs/pong/tickets/amazon"
	"code.justin.tv/cs/pong/tickets/processor"
	"code.justin.tv/cs/pong/tickets/twitch"
	salesforce "code.justin.tv/cs/salesforce-client"
	users "code.justin.tv/web/users-service/client/usersclient_internal"
	"github.com/pkg/errors"
	goji "goji.io"
	"goji.io/pat"
)

type Server struct {
	*goji.Mux
	usersClient           users.InternalClient
	twitchClient          twitch.Client
	amazonClient          amazon.Client
	ticketProcessorClient processor.Client
	deskClient            desk.Client
	serviceCloudClient    salesforce.Client
	deskPayloadSecret     string
}

func NewServer(usersClient users.InternalClient, twitchClient twitch.Client, amazonClient amazon.Client, ticketProcessorClient processor.Client, deskClient desk.Client, deskPayloadSecret string, serviceCloudClient salesforce.Client) (*Server, error) {

	s := Server{
		Mux:                   twitchhttp.NewServer(),
		usersClient:           usersClient,
		twitchClient:          twitchClient,
		amazonClient:          amazonClient,
		ticketProcessorClient: ticketProcessorClient,
		deskClient:            deskClient,
		serviceCloudClient:    serviceCloudClient,
		deskPayloadSecret:     deskPayloadSecret,
	}

	s.HandleFunc(pat.Post("/tickets/amazon"), s.createAmazonTicket)
	s.HandleFunc(pat.Post("/tickets/processor"), s.processTicket)

	return &s, nil
}

func handleError(w http.ResponseWriter, statusCode int, message string, err error, sendErrToUser bool) {
	err = errors.Wrap(err, message)
	logger.Errorf(err.Error())

	if sendErrToUser {
		http.Error(w, err.Error(), statusCode)
	} else {
		http.Error(w, message, statusCode)
	}
}
