# Scenario-Impacted customer contact prioritization

### Desk 
---
#### *Case Created* `Rule`:
* If `Case Channel` is `email`:  
	1. Trigger an App Action: `Pong Ticket Processor`

#### *Apps* `Custom Action`:
* Pong: Ticket Processor
	1. POST a JSON string to a URL:

```json
{
          "desk_case_id":  "{{case.id}}",
         "twitch_userid":  "{{case.custom_twitch_userid}}",
  "desk_customer_emails":  "{{customer.emails}}",
                "secret":  "TBD"
}
```
[//]: # (  )
#### Case `Filter`:
* **SIRT IMPACTED**
	1. `Case Labels` **Contains** `SIRT-IMPACTED`

### Pong
---
#### Storage
```go
impactMap := map[string]string{} //UserID: JiraID
```
> On startup, Pong should load a JSON file listing `{"userID": "JiraID", ... }` and populate the map with that data.
That JSON file should either be:
> * loaded locally from its own directory ( faster ) 
> * fetched from S3 ( ideal )

```go
GetSpecialUser(userID string) (*SpecialUser) { ... }

type SpecialUser struct {
	UserID    string
	JiraID    string
	Impacted  bool
}
```
#### New Route: `/tickets/processor`

#### Route Handler

```go
type ProcessorMessage struct {
	Secret             	string	`json:"secret"`
	DeskCaseID         	   int	`json:"desk_case_id"`
	TwitchUserID       	string	`json:"twitch_userid,omitempty"`
	DeskCustomerEmails 	string	`json:"desk_customer_emails"`
}
```

Step by Step

* if `UserID` exists in the payload
	1. Check it against the customer TuID set
* else
	1. Split the emails string ( it's a comma delimited string )
	1. Validate they're all at least email addresses ( `^\S+?@\S+?\.\S+?$` )
	1. Users Service -> Get users with the emails from the previous step
	1. Check resulting userIDs against customer TuID set

* If the customer exists in the TuID set
	1. Update the Desk case with the JIRA ID from the impact set and the `SIRT-IMPACTED` label
* else
	1. No action

```go
	var labels []string
	user, err := GetSpecialUser(userID)

	if err != nil {
	}
	if user.Impacted {
		append(labels, "SIRT-IMPACTED")
		append(labels, user.JiraID)
	}

	_, err = deskClient.UpdateCase(ctx,
		&desk.Case{
			ID:     json.desk_case_id,
			Labels: labels,
		})
	if err != nil {
		return errors.Wrapf(err, "failed to update Desk id %s with SIRT-IMPACTED/%s", id, user.sirtID)
	}
```
