freeStyleJob('cs-pong') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'cs/pong', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json'
    saveDeployArtifact 'cs/pong', '.manta'
    //saveChasquiArtifact 'pong', '.manta', 'deployments-pong', '641044725657'
    saveChasquiArtifact 'pong', '.manta', 'deployments-pong', '465369119046'
  }
}

freeStyleJob('cs-pong-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo cs/pong --dir /opt/twitch/pong'
  }
}
 
freeStyleJob('cs-pong-deploy-chasqui') {
  using 'TEMPLATE-deploy-aws-chasqui'
  steps {
    deployChasquiArtifact 'pong', '\$ENVIRONMENT', 'deployments-pong'
  }
}