package logger

import (
	"fmt"
	"log"

	"code.justin.tv/common/config"
)

func Infof(format string, v ...interface{}) {
	log.Printf("INFO "+format, v...)
}

func Errorf(format string, v ...interface{}) {
	log.Printf("ERROR "+format, v...)

	if rb := config.RollbarErrorLogger(); rb != nil {
		err := fmt.Errorf(format, v...)
		rb.Error(err)
	}
}
