resource "aws_sns_topic" "pagerduty_alarm" {
  name = "pagerduty_pong"
}

resource "aws_sns_topic_subscription" "pagerduty_subscription" {
  topic_arn = "${aws_sns_topic.pagerduty_alarm.arn}"
  protocol  = "https"
  endpoint  = "${var.pagerduty_url}"
  endpoint_auto_confirms = true
}

module "internal_app_elb_alarms" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/elb/alarms"
  elb_name = "${aws_elb.internal_app_elb.name}"
  elb_http_4xx_threshold       = "10"
  elb_http_5xx_threshold       = "10"
  elb_elb_4xx_threshold        = "10"
  elb_elb_5xx_threshold        = "10"
  elb_surge_threshold          = "100"
  elb_latency_threshold        = "10.0"
  backend_conn_error_threshold = "100"
  action_arns = "${aws_sns_topic.pagerduty_alarm.arn}"
}

module "external_app_elb_alarms" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/elb/alarms"
  elb_name = "${aws_elb.external_app_elb.name}"
  elb_http_4xx_threshold       = "10"
  elb_http_5xx_threshold       = "10"
  elb_elb_4xx_threshold        = "10"
  elb_elb_5xx_threshold        = "10"
  elb_surge_threshold          = "100"
  elb_latency_threshold        = "10.0"
  backend_conn_error_threshold = "100"
  action_arns = "${aws_sns_topic.pagerduty_alarm.arn}"
}

resource "aws_cloudwatch_metric_alarm" "app-cpu" {
  alarm_name = "${var.name}-${var.environment}-app-cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "10"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "app-status" {
  alarm_name = "${var.name}-${var.environment}-app-status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-cpu" {
  alarm_name = "${var.name}-${var.environment}-canary-app-cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "10"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-status" {
  alarm_name = "${var.name}-${var.environment}-canary-app-status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "ingress-amazon" {
  alarm_name = "${var.name}-${var.environment}-ingress-amazon"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "ApproximateNumberOfMessagesVisible"
  namespace = "AWS/SQS"
  period = "60"
  statistic = "Average"
  threshold = "10"
  dimensions = {QueueName = "${aws_sqs_queue.ingress_amazon_queue.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "ingress-amazon-ack" {
  alarm_name = "${var.name}-${var.environment}-ingress-amazon-ack"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "ApproximateNumberOfMessagesVisible"
  namespace = "AWS/SQS"
  period = "60"
  statistic = "Average"
  threshold = "10"
  dimensions = {QueueName = "${aws_sqs_queue.ingress_amazon_ack_queue.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "ingress-amazon-deadletter" {
  alarm_name = "${var.name}-${var.environment}-ingress-amazon-deadletter"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "ApproximateNumberOfMessagesVisible"
  namespace = "AWS/SQS"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {QueueName = "${aws_sqs_queue.ingress_amazon_deadletter_queue.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "ingress-amazon-ack-deadletter" {
  alarm_name = "${var.name}-${var.environment}-ingress-amazon-ack-deadletter"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "ApproximateNumberOfMessagesVisible"
  namespace = "AWS/SQS"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {QueueName = "${aws_sqs_queue.ingress_amazon_ack_deadletter_queue.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}
