resource "aws_elb" "external_app_elb" {
  name = "${var.name}-${var.environment}-app-external"
  security_groups = ["${var.twitch_subnets_sg}",
    "${aws_security_group.external_app_elb.id}"]
  subnets = ["${var.public_a}",
    "${var.public_b}",
    "${var.public_c}"]
  internal = false
  cross_zone_load_balancing = true
  connection_draining = true

  listener {
    instance_port = 8000
    instance_protocol = "http"
    lb_port = 443
    lb_protocol = "https"
    ssl_certificate_id = "${var.ssl_certificate_arn}"
  }

  health_check {
    healthy_threshold = 3
    unhealthy_threshold = 5
    timeout = 10
    target = "HTTP:8000/debug/running"
    interval = 30
  }

  tags {
    Name = "${var.name}-${var.environment}-app-external"
    Owner = "${var.owner}"
    Project = "${var.project}"
  }
}

resource "aws_security_group" "external_app_elb" {
  name = "${var.name}-${var.environment}-app-external"
  description = "Allow all HTTPS inbound traffic"
  vpc_id = "${var.vpc_id}"

  ingress {
    from_port = 443
    to_port = 443
    protocol = "TCP"
    cidr_blocks = ["0.0.0.0/0"]
  }

  egress {
    from_port = 0
    to_port = 0
    protocol = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name = "${var.name}-${var.environment}-app-external"
    Owner = "${var.owner}"
    Project = "${var.project}"
  }
}


resource "aws_route53_record" "external_app_elb" {
    provider = "aws.dns"
    zone_id = "${var.hard_ids["public_twitch_r53"]}"
    type = "A"
    name = "${var.route53_external_name}"

    alias {
      name = "${aws_elb.external_app_elb.dns_name}"
      zone_id = "${aws_elb.external_app_elb.zone_id}"
      evaluate_target_health = true
    }
}
