resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "",
      "Action": "sts:AssumeRole",
      "Principal": {
        "AWS": "arn:aws:iam::465369119046:role/developers",
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "sqs_policy" {
  name = "${var.iam_role_name}-${var.environment}-sqs-policy"
  role = "${aws_iam_role.app.id}"
  depends_on = ["aws_iam_role.app"]
  policy = <<EOF
{
  "Version":"2012-10-17",
  "Statement":[
    {
      "Action": [
        "sqs:ChangeMessageVisibility",
        "sqs:ChangeMessageVisibilityBatch",
        "sqs:DeleteMessage",
        "sqs:DeleteMessageBatch",
        "sqs:GetQueueAttributes",
        "sqs:GetQueueUrl",
        "sqs:ReceiveMessage"
      ],
      "Effect": "Allow",
      "Resource": [
        "${aws_sqs_queue.ingress_amazon_queue.arn}",
        "${aws_sqs_queue.ingress_amazon_deadletter_queue.arn}",
        "${aws_sqs_queue.ingress_amazon_ack_queue.arn}",
        "${aws_sqs_queue.ingress_amazon_ack_deadletter_queue.arn}"
      ]
    },
    {
      "Action": [
        "sqs:GetQueueUrl",
        "sqs:SendMessage",
        "sqs:SendMessageBatch"
      ],
      "Effect": "Allow",
      "Resource": [
        "${var.egress_amazon_queue_arn}"
      ]
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "sandstorm_policy" {
  name = "${var.iam_role_name}-${var.environment}-sandstorm-policy"
  role = "${aws_iam_role.app.id}"
  depends_on = ["aws_iam_role.app"]
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${var.sandstorm_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  roles = ["${aws_iam_role.app.name}"]
}
