resource "aws_sqs_queue" "ingress_amazon_queue" {
  name = "${var.name}-${var.environment}-ingress-amazon"
  visibility_timeout_seconds = 120    // 2 minutes
  message_retention_seconds = 1209600 // 14 days
  redrive_policy = "{\"deadLetterTargetArn\":\"${aws_sqs_queue.ingress_amazon_deadletter_queue.arn}\",\"maxReceiveCount\":5}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Id": "arn:aws:sqs:${var.region}:${var.account_id}:${var.name}-${var.environment}-ingress-amazon/policy",
    "Statement": [
        {
            "Sid": "Ingress_Amazon_Send",
            "Effect": "Allow",
            "Principal": {
                "AWS": "${var.amazon_arn}"
            },
            "Action": ["sqs:GetQueueUrl","sqs:SendMessage"],
            "Resource": "arn:aws:sqs:${var.region}:${var.account_id}:${var.name}-${var.environment}-ingress-amazon"
        }
    ]
}
EOF
}

resource "aws_sqs_queue" "ingress_amazon_deadletter_queue" {
  name = "${var.name}-${var.environment}-ingress-amazon-deadletter"
  visibility_timeout_seconds = 120    // 2 minutes
  message_retention_seconds = 1209600 // 14 days
}

resource "aws_sqs_queue" "ingress_amazon_ack_queue" {
  name = "${var.name}-${var.environment}-ingress-amazon-ack"
  visibility_timeout_seconds = 120    // 2 minutes
  message_retention_seconds = 1209600 // 14 days
  redrive_policy = "{\"deadLetterTargetArn\":\"${aws_sqs_queue.ingress_amazon_ack_deadletter_queue.arn}\",\"maxReceiveCount\":5}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Id": "arn:aws:sqs:${var.region}:${var.account_id}:${var.name}-${var.environment}-ingress-amazon-ack/policy",
    "Statement": [
        {
            "Sid": "Ingress_Amazon_Send",
            "Effect": "Allow",
            "Principal": {
                "AWS": "${var.amazon_arn}"
            },
            "Action": ["sqs:GetQueueUrl","sqs:SendMessage"],
            "Resource": "arn:aws:sqs:${var.region}:${var.account_id}:${var.name}-${var.environment}-ingress-amazon-ack"
        }
    ]
}
EOF
}

resource "aws_sqs_queue" "ingress_amazon_ack_deadletter_queue" {
  name = "${var.name}-${var.environment}-ingress-amazon-ack-deadletter"
  visibility_timeout_seconds = 120    // 2 minutes
  message_retention_seconds = 1209600 // 14 days
}
