variable "hard_ids" {
    default {
        r53                        = "ZRG00SM48517Z"
        twitch_r53                 = "Z127RUWUPOFGHX"
        public_twitch_r53          = "ZL2XLO1TDFXZB"
        prod_vpc                   = "vpc-0213b167"
        dev_vpc                    = "vpc-1e13b17b"
        dev_twitch_security_group  = "sg-f1edb194"
        prod_twitch_security_group = "sg-27d18d42"

        prod_db_subnets = "prod"
        dev_db_subnets  = "dev"

        prod_avail = "subnet-faa4239f,subnet-88a207ff,subnet-9c4ab1c5"
        dev_avail = "subnet-d4a423b1,subnet-67ad0810,subnet-894ab1d0"
        dev_avail_0 = "subnet-d4a423b1"
    }
}

# Service name used for AWS tagging among other things
variable "name" {}

# DNS safe service name
variable "hostname" {}

# Domain
variable "domain" {
  default = {
    "production" = "prod.us-west2.justin.tv"
    "staging"    = "dev.us-west2.justin.tv"
  }
}

# AWS Account
variable "account" {
  default = {
    "production" = "twitch-web-aws"
    "staging"    = "twitch-web-dev"
  }
}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/twitch-create-service
variable "project" {}

# Region this service resides in
variable "region" {
  default = "us-west-2"
}

# EC2 Instance Image
variable "ami" {
  default = "ami-045936138699538b2"
}

# EC2 Instance Type
variable "instance_type" {
  default = "c4.large"
}

# Largest a service cluster will grow to
variable "max_size" {
  default = 0
}

# Smallest a service cluster will shrink down to
variable "min_size" {
  default = 0
}

# Number of canary instances
variable "canary_size" {
  default = 0
}

# Service environment
variable "environment" {}

# Amount of diskspace allocated to the root drive. (GB)
variable "root_volume_size" {
  default = 256
}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "pong"
}

# SSL certificate to use with HTTPS traffic
variable "ssl_certificate_arn" {}

# External DNS name
variable "route53_external_name" {}

# Sandstorm role to assume to access secrets
variable "sandstorm_arn" {}

# The Amazon ARN to grant permissions to
variable "amazon_arn" {}

# The ARN for Amazon's SQS queue
variable "egress_amazon_queue_arn" {}

# The URL endpoint for PagerDuty alarms
variable "pagerduty_url" {}

variable "asg_lambda_arn" {}
variable "vpc_id" {}
variable "twitch_subnets_sg" {}
variable "account_id" {}

variable "service_subnets" {
}
variable "public_a" {}
variable "public_b" {}
variable "public_c" {}