module "pong" {
  source                  = "../modules/pong"
  name                    = "pong"
  hostname                = "pong"
  owner                   = "fire@twitch.tv"
  project                 = "cs/pong"
  ami                     = "ami-045936138699538b2"
  instance_type           = "c4.large"
  max_size                = 3
  min_size                = 3
  canary_size             = 1
  environment             = "production"
  root_volume_size        = "256"
  iam_role_name           = "pong"
  ssl_certificate_arn     = "arn:aws:iam::641044725657:server-certificate/wildcard.prod.us-west2.twitch.tv"
  route53_external_name   = "pong.prod.us-west2.twitch.tv"
  sandstorm_arn           = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/pong-production"
  amazon_arn              = "arn:aws:iam::277306168768:user/tails-sqs-user"
  egress_amazon_queue_arn = "arn:aws:sqs:us-east-1:277306168768:pong-ingress-queue"
  pagerduty_url           = "https://events.pagerduty.com/integration/8ef0b62a5254435fbde327ad8702e95c/enqueue"
}
