module "pong" {
  source                  = "../modules/pong"
  name                    = "pong"
  hostname                = "pong"
  owner                   = "fire@twitch.tv"
  project                 = "cs/pong"
  ami                     = "ami-045936138699538b2"
  instance_type           = "c4.large"
  max_size                = 2
  min_size                = 2
  canary_size             = 0
  environment             = "staging"
  root_volume_size        = "256"
  iam_role_name           = "pong"
  ssl_certificate_arn     = "arn:aws:iam::465369119046:server-certificate/wildcard.dev.us-west2.twitch.tv"
  route53_external_name   = "pong.dev.us-west2.twitch.tv"
  sandstorm_arn           = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/pong-staging"
  amazon_arn              = "arn:aws:iam::256445009424:user/tails-sqs"
  egress_amazon_queue_arn = "arn:aws:sqs:us-west-2:256445009424:pong-ingress-queue"
  pagerduty_url           = "https://events.pagerduty.com/integration/cec7303bd5f44e5baa7a6739da7adebb/enqueue"
  asg_lambda_arn = "arn:aws:lambda:us-west-2:465369119046:function:asg_route53_update"
  vpc_id ="vpc-230f5e46"
  twitch_subnets_sg= "sg-c06b03a4"
  account_id = "465369119046"
  service_subnets="subnet-b0af88d5,subnet-1c76336b,subnet-c1d54a98"
  public_a = "subnet-ced54a97"
  public_b = "subnet-b3af88d6"
  public_c = "subnet-1e763369"
}
