// This logic is temporary, until Amazon's code moves out of TAILS.
// If you're seeing this and the code hasn't been removed, email
// Meir Wasserman at mwssrm@amazon.com

package amazon

import (
	"strings"

	"code.justin.tv/common/config"
)

const defaultC2CIDKey = "default"

var stagingC2CIDs = map[string]string{
	"us":            "ede82ca3-e727-456d-bdce-a2fe35b591de",
	defaultC2CIDKey: "ede82ca3-e727-456d-bdce-a2fe35b591de",
}

var productionC2CIDs = map[string]string{
	"us":            "6b55d317-2f87-40fd-a209-6bd9e6409522",
	"ca":            "0e2292a2-abbf-473b-90b9-1ee462c38280",
	"uk":            "31d7c2de-3e96-4452-9770-99eb1c65997a",
	"gb":            "31d7c2de-3e96-4452-9770-99eb1c65997a",
	"it":            "26279e19-ca5a-4e9e-a081-710ebaf0121c",
	"es":            "07438c1c-5ca0-4bff-8055-46d5177070de",
	"fr":            "133ce8c0-7274-4de0-aede-117dc448d793",
	"de":            "4db92a07-3e85-4bf8-be60-3171b94fc726",
	"mx":            "3aeec2e6-328e-45e4-8966-87f3dcad9d7c",
	defaultC2CIDKey: "6b55d317-2f87-40fd-a209-6bd9e6409522",
}

func C2CIDForCountry(country string) string {
	var ids map[string]string
	if config.Environment() == "staging" {
		ids = stagingC2CIDs
	} else if config.Environment() == "production" {
		ids = productionC2CIDs
	} else {
		return ""
	}

	country = strings.ToLower(country)
	id, ok := ids[country]
	if !ok {
		return ids[defaultC2CIDKey]
	}
	return id
}
