package amazon

import (
	"crypto/rand"
	"crypto/rsa"
	"testing"

	"code.justin.tv/cs/pong/tickets"
	"github.com/stretchr/testify/assert"
)

func TestEncrypt(t *testing.T) {
	privateKey, err := rsa.GenerateKey(rand.Reader, 2048)
	assert.NoError(t, err)

	publicKey := &privateKey.PublicKey

	t1 := tickets.Twitch{
		Body:           "body",
		AmazonTicketID: "amazon-ticket-id",
		TwitchTicketID: "twitch-ticket-id",
		TwitchUserID:   "twitch-user-id",
	}
	encrypted, err := encrypt(publicKey, t1)
	assert.NoError(t, err)

	var t2 tickets.Twitch
	err = decrypt(privateKey, &t2, encrypted)
	assert.NoError(t, err)
	assert.Equal(t, t1, t2)
}
