package processor

import (
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/pkg/errors"

	desk "code.justin.tv/cs/desk-client"
	salesforce "code.justin.tv/cs/salesforce-client"
	users "code.justin.tv/web/users-service/client/usersclient_internal"
)

type Client interface {
	GetSpecialUser(userID string) *SpecialUser
}

type Config struct {
	DeskClient         desk.Client
	ServiceCloudClient salesforce.Client
	UsersClient        users.InternalClient
	Stats              statsd.Statter
}

type client struct {
	deskClient         desk.Client
	serviceCloudClient salesforce.Client
	usersClient        users.InternalClient
	stats              statsd.Statter
	userMap            SpecialUserMap
}

func NewClient(conf Config) (Client, error) {

	specialUserMap, err := buildSpecialUserMap(userList())
	if err != nil {
		return nil, errors.Wrapf(err, "Couldn't build special user map")
	}

	return &client{
		deskClient:         conf.DeskClient,
		serviceCloudClient: conf.ServiceCloudClient,
		usersClient:        conf.UsersClient,
		stats:              conf.Stats,
		userMap:            *specialUserMap,
	}, nil
}
