package processor

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestBuildSpecialUserMap(t *testing.T) {

	atr := getSampleUserList()
	userMap, err := buildSpecialUserMap(atr)
	assert.NoError(t, err)

	testClient := &client{
		userMap: *userMap,
	}

	assert.True(t, testClient.GetSpecialUser("12345").SirtImpacted, "Users with a SIRT- jira should have SirtImpacted true")
	assert.False(t, testClient.GetSpecialUser("1234567").SirtImpacted, "Users without a SIRT- jira should have SirtImpacted false")
	assert.Nil(t, testClient.GetSpecialUser("1337"), "users that don't exist in the set should return nil")
	assert.Exactly(t, testClient.GetSpecialUser("123456").Language, "en_gb", "Country codes should be normalized to Desk's [code]_[code] format")

}

func getSampleUserList() *strings.Reader {

	return strings.NewReader(`[
{"user_id":"12345", "lang":"en", "jira_id": "SIRT-0987"},
{"user_id":"123456", "lang":"en-gb", "jira_id": "SIRT-0987"},
{"user_id":"1234567", "lang":"zh", "jira_id": "SUPPORT-379485"},
{"user_id":"123456789", "lang":"es", "jira_id": "SIRT-1"}
]`)
}
