package tickets

import (
	"fmt"
	"time"
)

type Amazon struct {
	Subject            string    `json:"subject"`
	Body               string    `json:"body"`
	TwitchTicketID     string    `json:"twitch_ticket_id"`
	TwitchUserID       string    `json:"twitch_user_id"`
	TwitchUsername     string    `json:"twitch_username"`
	TwitchPartner      bool      `json:"twitch_partner"`
	AmazonPrime        bool      `json:"amazon_prime"`
	AmazonPrimeCountry string    `json:"amazon_prime_country"`
	Created            time.Time `json:"created"`

	// This field is temporary, until Amazon's code moves out of TAILS.
	// If you're seeing this and the code hasn't been removed, email
	// Meir Wasserman at mwssrm@amazon.com
	C2CID string `json:"c2cid"`
}

// Intentionally redact data to prevent leaking PII
func (a Amazon) String() string {
	return fmt.Sprintf("Twitch Ticket ID %s, Created %v", a.TwitchTicketID, a.Created)
}

type AmazonAck struct {
	TwitchTicketID string `json:"twitch_ticket_id"`
	AmazonMediaID  string `json:"amazon_media_id"`
}

// Intentionally redact data to prevent leaking PII
func (aa AmazonAck) String() string {
	return fmt.Sprintf("Twitch Ticket ID %s, Amazon Media ID %s", aa.TwitchTicketID, aa.AmazonMediaID)
}

type Twitch struct {
	Body           string `json:"problem_statement"`
	AmazonTicketID string `json:"csc_case_id"`
	TwitchTicketID string `json:"twitch_ticket_id"`
	TwitchUserID   string `json:"twitch_user_id"`
}

// Intentionally redact data to prevent leaking PII
func (t Twitch) String() string {
	return fmt.Sprintf("Amazon Ticket ID %s", t.AmazonTicketID)
}
