package twitch

import (
	"context"

	"github.com/cactus/go-statsd-client/statsd"

	desk "code.justin.tv/cs/desk-client"
	"code.justin.tv/cs/pong/tickets"
	"code.justin.tv/cs/pong/turbo"
	salesforce "code.justin.tv/cs/salesforce-client"
	samus "code.justin.tv/samus/gateway/client"
	users "code.justin.tv/web/users-service/client/usersclient_internal"
)

type Client interface {
	CreateTicket(ctx context.Context, t tickets.Twitch) error
	MarkTicketTransferred(ctx context.Context, id string, amazonMediaID string) error
}

type Config struct {
	DeskClient         desk.Client
	ServiceCloudClient salesforce.Client
	UsersClient        users.InternalClient
	TurboClient        turbo.Client
	SamusClient        samus.Client
	Stats              statsd.Statter
}

type client struct {
	deskClient         desk.Client
	serviceCloudClient salesforce.Client
	usersClient        users.InternalClient
	turboClient        turbo.Client
	samusClient        samus.Client
	stats              statsd.Statter
}

func NewClient(conf Config) (Client, error) {
	return &client{
		deskClient:         conf.DeskClient,
		serviceCloudClient: conf.ServiceCloudClient,
		usersClient:        conf.UsersClient,
		turboClient:        conf.TurboClient,
		samusClient:        conf.SamusClient,
		stats:              conf.Stats,
	}, nil
}
