package twitch

import (
	"context"

	"code.justin.tv/cs/pong/tickets"
	"github.com/stretchr/testify/mock"
)

type MockedClient struct {
	mock.Mock
}

func (m *MockedClient) CreateTicket(ctx context.Context, t tickets.Twitch) error {
	args := m.Called(ctx, t)
	return args.Error(0)
}

func (m *MockedClient) MarkTicketTransferred(ctx context.Context, id, amazonMediaID string) error {
	args := m.Called(ctx, id, amazonMediaID)
	return args.Error(0)
}
