package twitch

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTicketBodySummary(t *testing.T) {
	tests := []struct {
		body      string
		numWords  int
		maxLength int
		expected  string
	}{
		{"Bacon", 5, 50, "Bacon"},
		{"Bacon", 0, 50, ""},
		{"Bacon", 5, 0, ""},

		{"Bacon ipsum dolor amet shank boudin turkey chuck", 5, 50, "Bacon ipsum dolor amet shank"},
		{"Bacon ipsum dolor amet shank boudin turkey chuck", 2, 50, "Bacon ipsum"},
		{"Bacon ipsum dolor amet shank boudin turkey chuck", 5, 10, "Bacon i..."},
	}

	for _, test := range tests {
		bodySummary := ticketBodySummary(test.body, test.numWords, test.maxLength)
		assert.Equal(t, test.expected, bodySummary)
	}
}
