package turbo

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	nitro "code.justin.tv/samus/nitro/rpc"
)

type Client interface {
	HasTurbo(ctx context.Context, userID string) (bool, error)
	HasPrime(ctx context.Context, userID string) (bool, error)
	PremiumStatus(ctx context.Context, userID string) (*nitro.GetPremiumStatusesResponse, error)
}

type client struct {
	Nitro          nitro.Nitro
	StatName       string
	StatSampleRate float64
}

func NewClient(conf twitchclient.ClientConf) (Client, error) {

	StatName := "service.turbo"
	StatSampleRate := 1.0

	nitroClient := nitro.NewNitroProtobufClient(conf.Host, twitchclient.NewHTTPClient(conf))

	return &client{nitroClient, StatName, StatSampleRate}, nil
}
