package turbo

import (
	"context"

	"github.com/stretchr/testify/mock"
)

type MockedClient struct {
	mock.Mock
}

func (m *MockedClient) HasTurbo(ctx context.Context, userID string) (bool, error) {
	args := m.Called(ctx, userID)
	return args.Bool(0), args.Error(1)
}

func (m *MockedClient) HasPrime(ctx context.Context, userID string) (bool, error) {
	args := m.Called(ctx, userID)
	return args.Bool(0), args.Error(1)
}
