package turbo

import (
	"context"

	nitro "code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
)

func (c *client) PremiumStatus(ctx context.Context, userID string) (*nitro.GetPremiumStatusesResponse, error) {
	request := &nitro.GetPremiumStatusesRequest{
		TwitchUserID: userID,
	}
	premiumStatuses, err := c.Nitro.GetPremiumStatuses(ctx, request)
	if err != nil {
		return nil, errors.Wrap(err, "failed to create nitro request")
	}
	return premiumStatuses, nil
}

func (c *client) HasTurbo(ctx context.Context, userID string) (bool, error) {
	premium, err := c.PremiumStatus(ctx, userID)
	if err != nil {
		return false, errors.Wrapf(err, "failed to fetch premium statuses for %s", userID)
	}

	if premium.HasTurbo || premium.HasPrime {

		return true, nil
	}

	return false, nil
}

func (c *client) HasPrime(ctx context.Context, userID string) (bool, error) {
	premium, err := c.PremiumStatus(ctx, userID)
	if err != nil {
		return false, errors.Wrapf(err, "failed to fetch premium statuses for %s", userID)
	}

	if premium.HasPrime {

		return true, nil
	}

	return false, nil
}
