# logx
logx adds structured logging to an application.

## Usage

#### Initializing

```go
// Call this early in your application, preferably right after the
// app fetches Rollbar credentials.
// See Config for more customization options.
InitDefaultLogger(logx.Config{
	RollbarToken: "my_rollbar_token",
	RollbarEnv:   "production",
})
```

#### Logging
```go
logx.Info(ctx, "This code flow /foo/bar/baz is not dead!")

logx.Warn(ctx, "User is rate limited", logx.Fields{"user_id": userID})

logx.Error(ctx, err, logx.Fields{
	"user_id": userID,
	"path":    request.URL.Path,
})

// This exits with exit code 1.
logx.Fatal(ctx, err, logx.Fields{
	"note": "initializing sitedb client"
})
```
