package logx

import "github.com/sirupsen/logrus"

// DefaultFormatter creates a default formatter
func DefaultFormatter() logrus.Formatter {
	return &logrus.TextFormatter{
		DisableColors:    true,
		DisableTimestamp: true,
	}
}

// NewOmitFieldsFormatter creates an omit fields formatter with
// internal formatter to format the log and fields to omit
func NewOmitFieldsFormatter(formatter logrus.Formatter, fields ...string) logrus.Formatter {
	return &omitFieldsFormatter{
		formatter: formatter,
		omit:      fields,
	}
}

// omitFieldsFormatter is a Formatter that does not log given fields.
type omitFieldsFormatter struct {
	formatter logrus.Formatter
	omit      []string
}

func (f *omitFieldsFormatter) Format(e *logrus.Entry) ([]byte, error) {
	for _, field := range f.omit {
		delete(e.Data, field)
	}
	return f.formatter.Format(e)
}
