package ptr

import "time"

// Bool returns a pointer to a bool.
func Bool(v bool) *bool { return &v }

// Int returns a pointer to an int.
func Int(v int) *int { return &v }

// Int32 returns a pointer to an int32
func Int32(v int32) *int32 { return &v }

// Int64 returns a pointer to an int64
func Int64(v int64) *int64 { return &v }

// String returns a pointer to a string.
func String(v string) *string { return &v }

// Time returns a pointer to a Time object.
func Time(v time.Time) *time.Time { return &v }
