# desk-client
[![GoDoc](https://godoc.internal.justin.tv/code.justin.tv/cs/desk-client?status.png)](https://godoc.internal.justin.tv/code.justin.tv/cs/desk-client)

Package desk provides structs and functions for interacting with version 2 of
the Salesforce Desk API.

For documentation, [click here](https://godoc.internal.justin.tv/code.justin.tv/cs/desk-client).

### Client

When creating the client, you must specify authentication parameters. These
parameters can be found in the "API - My Applications" section of the Desk
Admin UI.

```go
conf := desk.Config{
	Endpoint:       "https://help.twitch.tv",
	ConsumerKey:    "consumer-key",
	ConsumerSecret: "consumer-secret",
	AccessToken:    "access-token",
	AccessSecret:   "access-secret",
	Stats:          stats,
}
client := desk.NewClient(conf)
```

This client will perform API operations on the Desk portal defined by the
`Endpoint` parameter, while automatically handling authentication.

### Types

When creating, updating, or deleting entities in Desk, be sure to use the
pre-defined types in this package. For example:

* `desk.True` instead of `true`
* `desk.StatusNew` instead of `"new"`
* `desk.DirectionIn` instead of `"in"`

Not using these types will cause confusion and nasty side effects.

### Cases

To create a case, provide data for the case and the initial message.

```go
c := &desk.Case{
	Type:   desk.TypeEmail,
	Labels: []string{desk.LabelAmazonTransferIn},
}
m := &desk.CaseMessage{
	Direction: desk.DirectionIn,
	From:      "bob@ross.com",
	To:        "support@twitch.tv",
	Subject:   "The Joy of Painting",
	Body:      "Every day is a good day when you paint - Bob Ross",
}
createdCase, err := client.CreateCase(c, m)
```

When updating a case, you must at least provide the case's ID.

```go
c := &desk.Case{
	ID:     11923040,
	Status: desk.StatusNew,
}
updatedCase, err := client.UpdateCase(c)
```

Retrieve the original message that the case was opened with by providing the
case ID.

```go
message, err := client.CaseMessage(11911035)
```
