package desk

import (
	"context"

	"github.com/stretchr/testify/mock"
)

type MockedClient struct {
	mock.Mock
}

func (m *MockedClient) CreateCase(ctx context.Context, c *Case, cm *CaseMessage) (*Case, error) {
	args := m.Called(ctx, c, cm)
	return args.Get(0).(*Case), args.Error(1)
}

func (m *MockedClient) UpdateCase(ctx context.Context, c *Case) (*Case, error) {
	args := m.Called(ctx, c)
	return args.Get(0).(*Case), args.Error(1)
}

func (m *MockedClient) CaseMessage(ctx context.Context, caseID int) (*CaseMessage, error) {
	args := m.Called(ctx, caseID)
	return args.Get(0).(*CaseMessage), args.Error(1)
}
