package salesforce

import (
	"net/http"
	"time"

	"code.justin.tv/foundation/twitchclient"
)

type Config struct {
	URL          string
	ClientID     string
	ClientSecret string
	Username     string
	Password     string
}

type client struct {
	url          string
	clientID     string
	clientSecret string
	username     string
	password     string
	InstanceURL  string
	Token        string
	httpClient   *http.Client
	jsonClient   *twitchclient.JSONClient
}

type Token struct {
	AccessToken string `json:"access_token"`
	InstanceURL string `json:"instance_url"`
}

type CustomerCase struct {
	AccountID                   *string/* Lookup(Account) */ `json:"AccountId,omitempty"`                   // Account Name
	AmazonCaseID                *string/* Text(255) */ `json:"AmazonCaseID__c,omitempty"`                   // Amazon Case ID
	AmazonMediaID               *string/* Text(255) */ `json:"AmazonMediaID__c,omitempty"`                  // Amazon Media ID
	AssetID                     *string/* Lookup(Asset) */ `json:"AssetId,omitempty"`                       // Asset
	BroadcastCountry            *string/* Picklist */ `json:"BroadcastCountry__c,omitempty"`                // Broadcast Country
	BroadcastLanguage           *string/* Picklist */ `json:"BroadcastLanguage__c,omitempty"`               // Broadcast Language
	BusinessHoursID             *string/* Lookup(Business Hours) */ `json:"BusinessHoursId,omitempty"`      // Business Hours
	CaseAge                     *string/* Formula (Text) */ `json:"CaseAge__c,omitempty"`                   // Case Age
	CaseLanguage                *string/* Picklist */ `json:"CaseLanguage__c,omitempty"`                    // Case Language
	CaseNumber                  *int/* Auto Number */ `json:"CaseNumber,omitempty"`                         // Case Number
	Origin                      *string/* Picklist */ `json:"Origin,omitempty"`                             // Case Origin
	OwnerID                     *string/* Lookup(User,Group) */ `json:"OwnerId,omitempty"`                  // Case Owner
	Reason                      *string/* Picklist */ `json:"Reason,omitempty"`                             // Case Reason
	RecordTypeID                *string/* Record Type */ `json:"RecordTypeId,omitempty"`                    // Case Record Type
	SourceID                    *string/* Lookup(Social Post,Email Message) */ `json:"SourceId,omitempty"`  // Case Source
	Category                    *string/* Picklist */ `json:"Category__c,omitempty"`                        // Category
	IsClosedOnCreate            *bool/* Checkbox */ `json:"IsClosedOnCreate,omitempty"`                     // Closed When Created
	ContactEmail                *string/* Email */ `json:"ContactEmail,omitempty"`                          // Contact Email
	ContactFax                  *string/* Phone */ `json:"ContactFax,omitempty"`                            // Contact Fax
	ContactMobile               *string/* Phone */ `json:"ContactMobile,omitempty"`                         // Contact Mobile
	ContactID                   *string/* Lookup(Contact) */ `json:"ContactId,omitempty"`                   // Contact Name
	ContactPhone                *string/* Phone */ `json:"ContactPhone,omitempty"`                          // Contact Phone
	ContentType                 *string/* Picklist */ `json:"ContentType__c,omitempty"`                     // Content Type
	CreatedByID                 *string/* Lookup(User) */ `json:"CreatedById,omitempty"`                    // Created By
	CSCaseInteractionCount      *int/* Number(18, 0) */ `json:"CSCaseInteractionCount__c,omitempty"`        // CS Case Interaction Count
	CustomerName                *string/* Formula (Text) */ `json:"Customer_Name__c,omitempty"`             // Customer Name
	ClosedDate                  *time.Time/* Date/Time */ `json:"ClosedDate,omitempty"`                     // Date/Time Closed
	CreatedDate                 *time.Time/* Date/Time */ `json:"CreatedDate,omitempty"`                    // Date/Time Opened
	Description                 *string/* Long Text Area(32000) */ `json:"Description,omitempty"`           // Description
	DeskCaseID                  *string/* Text(255) */ `json:"DeskCaseID__c,omitempty"`                     // Desk Case ID
	DeskCaseMessage             *string/* Long Text Area(32768) */ `json:"DeskCaseMessage__c,omitempty"`    // Desk Case Message
	DeskLabels                  *string/* Long Text Area(32768) */ `json:"DeskLabels__c,omitempty"`         // Desk Labels
	DeskResolvedDate            *time.Time/* Date/Time */ `json:"DeskResolvedDate__c,omitempty"`            // Desk Resolved Date
	DeskTimeToClose             *int/* Formula (Number) */ `json:"DeskTimeToClose__c,omitempty"`            // Desk Time to Close
	DetailCategory              *string/* Picklist */ `json:"Detail_Category__c,omitempty"`                 // Detail Category
	Dummy                       *bool/* Checkbox */ `json:"Dummy__c,omitempty"`                             // Dummy
	IsEscalated                 *bool/* Checkbox */ `json:"IsEscalated,omitempty"`                          // Escalated
	FacebookURL                 *string/* url(255) */ `json:"FacebookURL__c,omitempty"`                     // Facebook url
	FirstName                   *string/* Text(255) */ `json:"First_Name__c,omitempty"`                     // First Name
	Group                       *string/* Picklist */ `json:"Group__c,omitempty"`                           // Group
	Comments                    *string/* Text Area(4000) */ `json:"Comments,omitempty"`                    // Internal Comments
	Labels                      *string/* Text(255) */ `json:"Labels__c,omitempty"`                         // Labels
	LastDeskSync                *time.Time/* Date/Time */ `json:"LastDeskSync__c,omitempty"`                // Last Desk Sync
	LastModifiedByID            *string/* Lookup(User) */ `json:"LastModifiedById,omitempty"`               // Last Modified By
	OperatingSystem             *string/* Picklist */ `json:"OperatingSystem__c,omitempty"`                 // Operating System
	ParentID                    *string/* Lookup(Case) */ `json:"ParentId,omitempty"`                       // Parent Case
	PathToPartnerCompletionDate *time.Time/* Date/Time */ `json:"PathToPartnerCompletionDate__c,omitempty"` // Path to Partner Completion Date
	Priority                    *string/* Picklist */ `json:"Priority,omitempty"`                           // Priority
	ReceivedBulkResponse        *bool/* Checkbox */ `json:"ReceivedBulkResponse__c,omitempty"`              // Received Bulk Response?
	Spammer                     *bool/* Checkbox */ `json:"Spammer__c,omitempty"`                           // Spammer
	Status                      *string/* Picklist */ `json:"Status,omitempty"`                             // Status
	SubCategory                 *string/* Picklist */ `json:"SubCategory__c,omitempty"`                     // Sub Category
	Subject                     *string/* Text(255) */ `json:"Subject,omitempty"`                           // Subject
	SuppliedName                *string/* Text(255) */ `json:"SuppliedName__c,omitempty"`                   // Supplied Name
	TwitchAffiliate             *bool/* Checkbox */ `json:"TwitchAffiliate__c,omitempty"`                   // Twitch Affiliate
	TwitchAmazonLinked          *bool/* Checkbox */ `json:"TwitchAmazonLinked__c,omitempty"`                // Twitch Amazon Linked
	TwitchBanned                *bool/* Checkbox */ `json:"TwitchBanned__c,omitempty"`                      // Twitch Banned
	TwitchDisplayName           *string/* Text(255) */ `json:"TwitchDisplayName__c,omitempty"`              // Twitch Display Name
	TwitchFollowers             *int/* Number(18, 0) */ `json:"TwitchFollowers__c,omitempty"`               // Twitch Followers
	TwitchPartner               *bool/* Checkbox */ `json:"TwitchPartner__c,omitempty"`                     // Twitch Partner
	TwitchPrime                 *bool/* Checkbox */ `json:"TwitchPrime__c,omitempty"`                       // Twitch Prime
	TwitchPrimeCountry          *string/* Text(255) */ `json:"TwitchPrimeCountry__c,omitempty"`             // Twitch Prime Country
	TwitchStatisticsLastUpdated *time.Time/* Date/Time */ `json:"TwitchStatisticsLastUpdated__c,omitempty"` // Twitch Statistics Last Updated
	TwitchSuspended             *bool/* Checkbox */ `json:"TwitchSuspended__c,omitempty"`                   // Twitch Suspended
	TwitchTurbo                 *bool/* Checkbox */ `json:"TwitchTurbo__c,omitempty"`                       // Twitch Turbo
	TwitchUserBanned            *bool/* Checkbox */ `json:"TwitchUserBanned__c,omitempty"`                  // Twitch User Banned
	TwitchUserID                *string/* Text(255) */ `json:"TwitchUserID__c,omitempty"`                   // Twitch User ID
	TwitchUserSuspended         *bool/* Checkbox */ `json:"TwitchUserSuspended__c,omitempty"`               // Twitch User Suspended
	TwitchUsername              *string/* Text(255) */ `json:"TwitchUsername__c,omitempty"`                 // Twitch username
	TwitchViews                 *int/* Number(18, 0) */ `json:"TwitchViews__c,omitempty"`                   // Twitch Views
	TwitterFollowerCount        *int/* Number(18, 0) */ `json:"TwitterFollowerCount__c,omitempty"`          // Twitter Follower Count
	TwitterURL                  *string/* url(255) */ `json:"TwitterURL__c,omitempty"`                      // Twitter url
	TwitterUserID               *string/* Text(255) */ `json:"TwitterUserID__c,omitempty"`                  // Twitter User ID
	Type                        *string/* Picklist */ `json:"Type,omitempty"`                               // Type
	WebCompany                  *string/* Text(80) */ `json:"SuppliedCompany,omitempty"`                    // Web Company
	WebEmail                    *string/* Email */ `json:"SuppliedEmail,omitempty"`                         // Web Email
	WebName                     *string/* Text(80) */ `json:"SuppliedName,omitempty"`                       // Web Name
	WebPhone                    *string/* Text(40) */ `json:"SuppliedPhone,omitempty"`                      // Web Phone
	YouTubeChannelID            *string/* Text(255) */ `json:"YouTubeChannelID__c,omitempty"`               // YouTube Channel ID
	YouTubeSubscriberCount      *int/* Number(18, 0) */ `json:"YouTubeSubscriberCount__c,omitempty"`        // YouTube Subscriber Count
	YouTubeURL                  *string/* url(255) */ `json:"YouTubeURL__c,omitempty"`                      // YouTube url
}

type TokenResponse struct {
	AccessToken      string `json:"access_token"`
	InstanceURL      string `json:"instance_url"`
	Error            string `json:"error"`
	ErrorDescription string `json:"error_description"`
}

type CreateApplicationResponse struct {
	ID      string   `json:"id"`
	Errors  []string `json:"errors"`
	Success bool     `json:"success"`
}
