package config

import (
	"bytes"
	"encoding/json"

	"code.justin.tv/chat/jsonconf"

	"testing"
)

func TestConfiguration(t *testing.T) {
	for envName, envConfig := range configs {

		var conf Config

		byteConfig, err := json.Marshal(*envConfig)

		bReader := bytes.NewReader(byteConfig)

		err = jsonconf.Read(&conf, bReader)
		if err != nil {
			t.Errorf("Invalid configuration for environment %s:", envName)
			t.Logf("%#v\n\n", err)
		}
	}

}
