package salesforce

import (
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

//Config is a Salesforce client config
type Config struct {
	URL          string
	ClientID     string
	ClientSecret string
	Username     string
	Password     string
}

type client struct {
	url          string
	clientID     string
	clientSecret string
	username     string
	password     string
	InstanceURL  string
	Token        string
	httpClient   *http.Client
	jsonClient   *twitchclient.JSONClient
}

type Token struct {
	AccessToken string `json:"access_token"`
	InstanceURL string `json:"instance_url"`
}

type CustomerCase struct {
	Origin             *string/* Picklist */ `json:"Origin,omitempty"`                   // Case Origin
	Subject            *string/* Text(255) */ `json:"Subject,omitempty"`                 // Subject
	Description        *string/* Long Text Area(32000) */ `json:"Description,omitempty"` // Description
	TwitchUserID       *string/* Text(255) */ `json:"TwitchUserID__c,omitempty"`         // Twitch User ID
	TwitchDisplayName  *string/* Text(255) */ `json:"TwitchDisplayName__c,omitempty"`    // Twitch Display Name
	TwitchUsername     *string/* Text(255) */ `json:"TwitchUsername__c,omitempty"`       // Twitch username
	AmazonCaseID       *string/* Text(255) */ `json:"AmazonCaseID__c,omitempty"`         // Amazon Case or Media ID
	TwitchTurbo        *bool/* Checkbox */ `json:"TwitchTurbo__c,omitempty"`             // Twitch Turbo
	SuppliedEmail      *string/* Email */ `json:"SuppliedEmail,omitempty"`               // Web Email
	TwitchAffiliate    *bool/* Checkbox */ `json:"TwitchAffiliate__c,omitempty"`         // Twitch Affiliate
	TwitchPartner      *bool/* Checkbox */ `json:"TwitchPartner__c,omitempty"`           // Twitch Partner
	TwitchLanguage     *string/* Text(255) */ `json:"TwitchLanguage__c"`                 // Twitch user language
	TwitchPrime        *bool/* Checkbox */ `json:"TwitchPrime__c,omitempty"`             // Twitch Prime
	TwitchAmazonLinked *bool/* Checkbox */ `json:"TwitchAmazonLinked__c,omitempty"`      // Twitch Amazon Linked
	TwitchPrimeCountry *string/* Text(255) */ `json:"TwitchPrimeCountry__c,omitempty"`   // Twitch Prime Country
	TwitchSuspended    *bool/* Checkbox */ `json:"TwitchSuspended__c,omitempty"`         // Twitch Suspended
	TwitchBanned       *bool/* Checkbox */ `json:"TwitchBanned__c,omitempty"`            // Twitch Banned
	Labels             *string/* Text(255) */ `json:"Labels__c,omitempty"`               // Labels

}

type CustomerCaseCreated string

type CustomerCaseUpdate struct {
	CaseID       *string `json:"caseId"`
	AmazonCaseID *string `json:"amazonCaseId"`
}

type CustomerCaseUpdateSuccess string

type CustomerCaseUpdateFailure struct {
	ErrorCode []string `json:"errorCode"`
	Message   []string `json:"message"`
}

type TokenResponse struct {
	AccessToken      string `json:"access_token"`
	InstanceURL      string `json:"instance_url"`
	Error            string `json:"error"`
	ErrorDescription string `json:"error_description"`
}

type CreateApplicationResponse struct {
	ID      string   `json:"id"`
	Errors  []string `json:"errors"`
	Success bool     `json:"success"`
}
