// run on https://help.twitch.tv/api/v2/articles?fields=id%2Csubject%2Cpublic_url&page=1&per_page=100 while logged into Desk
// json global provided for free via https://chrome.google.com/webstore/detail/json-formatter/bcjindcccaagfpapjjmafapmmgkkhgoa

// this fetches every article ( run against multiple pages with page=n if it's below current total ),
// and tests the body against the comma delimited list below.

// Edit this list for what you would like to search articles for
let filterString = "partnerhelp@twitch\.tv";

let Regexfilter  = new RegExp(filterString.split(/\s?,\s?/).join('|'), "ig");
let articles       = [];

json._embedded.entries.forEach((e, i, a) => {

    console.log(e.name);
    setTimeout(() => {
        fetch(e._links.self.href, {credentials: 'same-origin'})
            .then((response) => {
                if (!response.ok) {
                    throw Error(response.statusText);
                } else {
                    return response.json();
                }
            })
            .then((jsonf) => {
                let values = [e.id, e.subject, e.public_url, Regexfilter.test(jsonf.body) || false];
                articles.push(values);
                console.log(e, i, values)
            })
            .then(() => {
                if (i === a.length - 1) {
                    console.log(articles.filter(e => {
                        return e[3] !== false
                    }).map(e => {
                        return 'ID: ' + e[0] + '\nNAME: ' + e[1] + '\nArticle:\n' + e[2]
                    }).reduce((p, c) => {
                        return p + '\n---\n' + c
                    }, ''))
                }
            })
            .catch((error) => {
                console.log(error);
            });
    }, 1000 * i);

});
