// Run on an actual Desk page so you can get the CSRF token,
// like https://help.twitch.tv/admin
// or https://help.twitch.tv/agent
// otherwise the API may fail as unauthorized and terminate your session
// 
//the update payload itself
//a list of newline-delimited caseIDs
var caseUpdater_payload = `
`.trim(); //trims the value so there's no hanging whitespace
caseUpdater_timers = [], //just a place to stick the setTimeout timers
  caseUpdater_errors = [], //holds any errors to retry on
  caseUpdater_method = 'PATCH', // http method for updating cases
  caseUpdater_update = caseUpdater_payload // takes the newline-delimited list of case IDs
  .split('\n'); /// and splits it by the newline so we get an array of case IDs ( plus the header )
if (caseUpdater_update[0] === 'Case #') { //// then we check whether the first item is the header item
  caseUpdater_update = caseUpdater_update.slice(1); ///// and if it is, we get rid of that element
} ////// now we have an array of case IDs

// helper to call on a list with a delay between
function caseUpdater_updateMultiple(arrayOfIDs, statusString, labelsArray, delayInMS) {
  for (let i = arrayOfIDs.length - 1; i >= 0; i--) {
    let delay = delayInMS||1000; // fallback to 1 second if no delay is passed in
    console.log(delay,delayInMS);
    let timer = setTimeout(() => { // wrap the update call so that it doesn't run all of them in the array instantly
      caseUpdater_updateCase(arrayOfIDs[i], statusString, labelsArray) // update each case 
    }, delay * i); 
    caseUpdater_timers.push(timer); // push the timers to our array so we can cancel them if we need to
    console.log(i, `will run in ${(delay / 1000)}s ( ${(arrayOfIDs.length - 1)} s total )`) // log runs
  }
}

function caseUpdater_updateCase(id, statusString, labelsArray) {

  fetch(`/api/v2/cases/${id}`,
      {
        credentials: 'same-origin', // need to send cookies, not done by default
        method: caseUpdater_method, // post for creates, patch for updates
        body: JSON.stringify({
          'status': statusString, // new, open, pending, resolved
          'labels': labelsArray, // an array of text labels to apply to the case
          'label_action': 'append' // append the labels, we don't want to replace everything
        }), //not sure if we actually need to stringify this, but it works
        headers: {
          'Accept': '*/*',
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8', // it's actually javascript but for some reason that doesn't work?
          'X-CSRF-Token': ($('meta[name="csrf-token"]').attr('content')) // for some reason desk only requires a csrf token if it thinks the client is a browser
        },
      })
    .then((res) => {
      if (!res.ok) { // something went wrong with the call
        console.log('failure', ...arguments) // log the entire call
        caseUpdater_errors.push([...arguments]); // push the whole thing into the error array
      }
        console.log(`Updated ${id} to ${statusString} with labels [${labelsArray}]`)
      return res
    });
}

//caseUpdater_updateMultiple(caseUpdater_update, 'open', ['label_here'], 1000); 
