// run on https://help.twitch.tv/api/v2/macros?per_page=1000&page=1 while logged into Desk
// json global provided for free via https://chrome.google.com/webstore/detail/json-formatter/bcjindcccaagfpapjjmafapmmgkkhgoa

// desk doesn't have any way to do content or macro searches for macros
// this fetches every macro ( raise page if there's more than 1000 macros ), filters by those that have a quick reply action or,
// label ( depending on which mode you configure below ), and tests against the comma delimited list below.

// Edit this list for what you would like to search macros for
let filterString = "rules-of-conduct, terms_of_service, dmca-guidelines, terms-of-service";
let mode = 'reply';


let modes = {
    "reply": "set-case-quick-reply",
    "label": "-case-labels", // gets us both append- and set- case-labels actions
};
let Regexfilter = new RegExp(filterString.split(/\s?,\s?/).join('|'), "ig");
let RegexMode = new RegExp(modes[mode], "ig");
let macros = [];

json._embedded.entries.forEach((e, i, a) => {

    console.log(e.name);
    setTimeout(() => {
        fetch(e._links.actions.href + '?per_page=100', {
                credentials: 'same-origin'
            })
            .then((response) => {
                if (!response.ok) {
                    // desk will 403 on macros your user doesn't have access to
                    // TODO: figure out how desk actually determines whether a user "has access" to a macro
                    throw Error(response.statusText);
                } else {
                    return response.json();
                }
            })
            .then((jsonf) => {
                let values = [e.name, jsonf._embedded.entries.filter(o => {
                    return (Regexfilter.test([o.value].join(',')) && RegexMode.test(o.type))
                }).map(a => {
                    return a.value
                })[0] || false];
                macros.push(values);
                console.log(e, i, values)
            })
            .then(() => {
                if (i === a.length - 1) {
                    console.log(macros.filter(e => {
                        return e[1] !== false
                    }).map(e => {
                        return 'NAME: ' + e[0] // + '\nMACRO:\n' + e[1]
                    }).reduce((p, c) => {
                        return p + '\n---\n' + c
                    }, ''))
                }
            })
            .catch((error) => {
                console.log(error);
            });
    }, 1000 * i);

});
