// run on https://help.twitch.tv/api/v2/snippets?page=1&per_page=400 while logged in to Desk.
// json global provided for free via https://chrome.google.com/webstore/detail/json-formatter/bcjindcccaagfpapjjmafapmmgkkhgoa

// Desk returns blank snippets instead of system default lang snippets if a translation is missing for the requested snippet.
// this generates liquid templates to set local variables based on the content of global snippets
// if system snippets are blank, local is set to the english snippet value. Otherwise, they're set to the translated snippet.
// used in cs/desk-submitter


json._embedded.entries.filter(e => {
    return /twitch/ig.test(e.name)
}).reduce((p, c) => {
    if (c.text === '') { 
        return p; 
    } else {
        return p + '\n{% if system.snippets.' + c.name + ' != blank %}{% assign ' + c.name + ' = system.snippets.' + c.name + ' %}{% else %}{% assign ' + c.name + ' = "' + c.text + '" %}{% endif %}';
    }
}, '');

// Just grabbing TSV key:value for Sheets / translation requests
json._embedded.entries.filter(e => {
    return /twitch/ig.test(e.name)
}).reduce((p, c) => {
    if (c.text === '') { 
        return p; 
    } else {
        return p + c.name+'\t'+c.text+'\t\n'; 
    }
}, 'key\tenglish\ttranslation\tnotes\n');
