// Run on an actual Desk page so you can get the CSRF token,
// like https://help.twitch.tv/admin
// or https://help.twitch.tv/agent
// otherwise the API will fail as unauthorized and terminate your session
//the update payload itself
//a tsv of snippetID\tsnippetContent, baically copying those two columns straight out of the spreadsheet
//https://docs.google.com/spreadsheets/d/1Avs1FTWS8pSVbclMdlqxWlLpUeX-Q8Q2gzhELcdgQGs/edit#gid=1291838831
var payload = `
`.trim();                                   //trims the value so there's no hanging whitespace
timers = [],                                //just a place to stick the setTimeout timers
locale = 'de',                              //the localization for this payload - this could be done better
endpoint = 'translations',                  //the default endpoint for creating new translations
method = 'POST',                            //default method for creating new translations
update = payload                            // takes the multiline TSV in `payload`,
        .split('\n')                        //splits it into an array of single line strings
        .reduce((p,c,i,a)=>{ 
                var split = c.split('\t');  // splits each of those into an array of the key and its value
                if (split[0] !== 'key'){    // makes sure it's not the header line from the spreadsheet
                    p[split[0]] = split[1]; //and puts both in the accumulator that's returned at the end
                } return p
            },{});                          //which is assigned to `update`

Object.keys(update).forEach(function(key, index, array) {                       //loops through all the keys in tne new `update` object
  let content = update[key];                                                    // sets `content` to the snippet content
  forceUpdate(locale,key,content,endpoint,timers,method,index,array.length);    //calls the update function with all relevant data
});

function forceUpdate(locale,key,content,endpoint,timers,method,wait,total){

    let timer = setTimeout(()=>{                                                                        //calls fetch inside a timeout so we don't make a billion requests at once
        fetch(`/api/v2/snippets/${key}/${endpoint}`,                                                    // string templating makes this easy
        { 
          credentials: 'same-origin',                                                                   // need to send cookies, not done by default
          method: method,                                                                               // post for creates, patch for updates
          body: JSON.stringify({'locale':locale,'text':content}),                                       //not sure if we actually need to stringify this, but it works
          headers: { 
            'Accept': '*/*', 
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'X-CSRF-Token':($('meta[name="csrf-token"]').attr('content'))                               // for some reason desk only requires a csrf token if it thinks the client is a browser
          },
        })
        .then((res)=>{
          if (!res.ok && res.status === 409){                                                           // 409 is a conflict, which means the snippet already exists,
            forceUpdate(locale,key,content,`${endpoint}/${locale}`,timers,'PATCH',(total-wait)+1,total);// so we need to re-call this with patch to update instead
          } return res
        })
        .then((d)=>{
          console.log(wait,`(${total})`)                                                                // mostly just for debugging
        })
    }
    ,1000*wait);                                                                                        // we make the timer the current array index times 1 second
    timers.push(timer);                                                                                 // don't forget to actually put the timer reference somewhere so we can cancel it
    console.log(key,method,'wait time:', 1000*wait);                                                    // more debugging prints

}
